<?php

namespace App\Models\CaseFileItem;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CaseFileItem extends Model 
{

    protected $table = 'case_files_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('file', 'case_id', 'Judgment');

    public function case()
    {
        return $this->hasMany('Xcase');
    }

    public function judgment()
    {
        return $this->hasMany('Judgment');
    }

}